/* 
 *  UpdateCustomerEmailRequest.java
 * 
 *  Copyright 2016 Avaya Inc. All Rights Reserved.
 * 
 *  Usage of this source is bound to the terms described
 *  in AvayaLicenseSDK.rtf.
 * 
 *  Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 *  or Avaya Policy
 * 
 */
package com.avaya.ccs.javafxrefclient.request;

import com.avaya.ccs.javafxrefclient.Logger;
import com.avaya.ccs.api.EmailListEntryI;

public class UpdateCustomerEmailRequest extends InteractionRequest {

    private static final Logger LOG = Logger.getLogger(UpdateCustomerEmailRequest.class);
    private final EmailListEntryI emailEntry;

    public UpdateCustomerEmailRequest(String interactionID, EmailListEntryI emailEntry) {
        super(LOG, interactionID);
        this.emailEntry = emailEntry;
    }

    /**
     * The call method executes on the outgoingRequest thread
     *
     * @return
     * @throws Exception
     */
    @Override
    protected Object call() throws Exception {
        String methodName = "call() ";
        LOG.trace(methodName + "+");
        getInteraction().updateCustomerEmail(emailEntry);
        LOG.trace(methodName + "-");
        return null;
    }
}
